﻿var sessions = {
    context: $(".v-sessions"),
    datatable: null,
    refreshDataTable: function () {
        sessions.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".h-sessionsTable", sessions.context).a4datatable({
            height: "full",
            stateKey: "Sessions",
            ajaxAction: a4.getAction("GetSessions", "Diagnostics", "Settings"),
            columns: [
                { "Name": "SessionId", "Title": resources.Id, "Data": "Id", "Class": "id" },
                { "Name": "Created", "Title": resources.CreatedOn, "Data": "Created", "Type": "date" },
                { "Name": "Expires", "Title": resources.ExpirationDate, "Data": "Expires", "Type": "date" },
                { "Name": "LockDate", "Title": resources.LockedOn, "Data": "Locked", "Type": "date" },
                { "Name": "Flags", "Title": resources.Flags, "Data": "Flags" },
                { "Name": "ClientId", "Title": resources.Client, "Data": "ClientId" },
                { "Name": "UserId", "Title": resources.User, "Data": "UserId", "Sortable": false }
            ],
            localizableTexts: { "Search": resources.SearchSessions },
            CreateddefaultSorting: { Column: "SessionId", Ascending: false },
            advancedFilter: true
        });
    },
    bindEvents: function () {
        sessions.context.on("click", ".h-exportLogs", function () {
            var tableParams = sessions.datatable.a4datatable("getTableParams");
            var link = a4.getAction("ExportSessions", "Diagnostics", "Settings", { tableParams: JSON.stringify(tableParams) });
            a4.showBusyBox();

            a4.callServerMethod(link, {},
            function (result) {
                a4.hideBusyBox();
                window.location = a4.getAction("GetExportSessionsFile", "Diagnostics", "Settings", { filename: result });
            },
            function (error) {
                a4.onAjaxPageMethodError(error);
            });
        });
    }
}

$(document).ready(function () {
    if (sessions.context.length > 0) {
        sessions.initializeDataTable();
        sessions.bindEvents();
    }
});